    @extends('admin.layouts.app')

    @section('title', 'Data Shift')

    @section('content')

        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h4 class="fw-bold mb-1">Data Shift</h4>
                <small class="text-muted">Manajemen shift</small>
            </div>

            <button class="btn btn-primary btn-sm d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#tambahShift">
                <i class="fas fa-plus me-2"></i>Tambah Data
            </button>
        </div>

        <div class="card shadow-sm border-0">
            <div class="card-body">

                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Kode</th>
                            <th>Jam Masuk</th>
                            <th>Jam Pulang</th>
                            <th>Toleransi (menit)</th>
                            <th>Lintas Hari</th>
                            <th class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($shift as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->kode }}</td>
                                {{-- <td>
                                    <span class="badge bg-info text-dark">
                                        {{ $item->role }}
                                    </span>
                                </td> --}}
                                <td>{{ $item->jam_masuk }}</td>
                                <td>{{ $item->jam_pulang }}</td>
                                <td>{{ $item->toleransi_menit }}</td>
                                <td>{{ $item->lintas_hari }}</td>

                                <td class="text-center">
                                    <button data-bs-target="#ubahShift{{ $item->id }}" data-bs-toggle="modal"
                                        class="btn btn-sm btn-warning">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <button class="btn btn-sm btn-danger" data-bs-toggle="modal"
                                        data-bs-target="#hapusShift{{ $item->id }}">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            </div>
            @foreach ($shift as $item)
                @include('admin.shift.edit')
                @include('admin.shift.delete')
            @endforeach
        </div>
        @include('admin.shift.create')


    @endsection
